
#COMPILE EXE
#INCLUDE "win32api.inc"
#INCLUDE "pb_srvc.bas"

'-- Based on watchdog example by Balthasar Indermuehle:
'-- http://www.powerbasic.com/support/forums/Forum7/HTML/002651.html

'-- Requires Don Dickinson's PB Service installer/handler code
'-- available at http://www.greatwebdive.com

'-- *********************  NOTE ***********************************
'-- To install service:     DirMonitor -install
'-- To start service:       net start sDirMon
'-- To stop  service:       net stop sDirMon
'-- To remove service:      DirMonitor -uninstall

'-- Use the Windows admin tools to set the service to start automatically

$SERVICE_NAME = "sDirMon"
$SERVICE_DISPLAY_NAME = "Directory Monitor Service"

%MAX_DIRS = 16
%MAX_FILES = 1024

TYPE CmdInfoType
    Cmd AS ASCIIZ * 4096
    Path AS ASCIIZ * %MAX_PATH
END TYPE

GLOBAL CmdInfo() AS CmdInfoType
GLOBAL hLogFile AS LONG

'-- This little feller was missing in win32api.inc:
DECLARE FUNCTION ReadDirectoryChangesW LIB "kernel32.dll" ALIAS "ReadDirectoryChangesW" (BYVAL hDirectory AS LONG, BYVAL lpBuffer AS LONG, _
                                                           BYVAL nBufferLength AS LONG, BYVAL bWatchSubtree AS LONG, _
                                                           BYVAL dwNotifyFilter AS INTEGER, BYREF lpBytesReturned AS INTEGER, _
                                                           BYVAL lpOverlapped AS LONG, BYVAL lpCompletionRoutine AS LONG) AS LONG

'-- Print sOut to log file
SUB PrintLog (SOut AS STRING)
    PRINT #hLogFile, DATE$ & " " & TIME$ & " " & sOut
END SUB

'-- Read a section from .ini file into items() array
FUNCTION GetSection(section AS ASCIIZ, inifile AS ASCIIZ, items() AS STRING) AS LONG
    LOCAL buffer AS STRING
    LOCAL aptr AS ASCIIZ PTR
    LOCAL x AS LONG
    LOCAL res AS LONG

    Buffer = STRING$(65536, 0)
    res = GetPrivateProfileSection(section, BYVAL STRPTR(Buffer), LEN(Buffer), inifile)
    aptr = STRPTR(buffer)

    WHILE LEN(@aptr)
        INCR x
        items(x) = @aptr
        aptr = aptr + LEN(@aptr) + 1
    WEND

    items(x) = RTRIM$(items(x))

    FUNCTION = x
END FUNCTION

'-- Main monitor thread
FUNCTION MonitorThread(BYVAL x AS LONG) AS LONG

    LOCAL i AS LONG
    LOCAL lRet AS LONG
    DIM   hWatchThread() AS LONG
    LOCAL dirCount AS LONG
    DIM   DirList(%MAX_DIRS) AS STRING
    LOCAL IniFile AS STRING
    LOCAL foo AS LONG
    LOCAL szExePath AS ASCIIZ * %MAX_PATH
    LOCAL LogFile AS STRING

    REDIM CmdInfo(%MAX_DIRS) AS CmdInfoType

    '-- Get this .exe file's path
    GetModuleFileName  %NULL ,szExePath, BYVAL %MAX_PATH
    szExePath = LEFT$( szExePath, INSTR(-1, szExePath, "\") )

    '-- Set the .ini and .log file paths
    IniFile = TRIM$(szExePath) & "DirMonitor.ini"
    LogFile = TRIM$(szExePath) & "DirMonitor.log"

    '-- Open log file
    hLogFile = FREEFILE
    OPEN LogFile FOR APPEND LOCK SHARED AS #hLogFile

    PrintLog "Start Monitor Thread"

    '-- Read "Directories" section from ini file
    dirCount = GetSection("Directories", BYCOPY IniFile, DirList())
    IF dirCount > %MAX_DIRS THEN dirCount = %MAX_DIRS

    '-- Redim structure to actual count of dirs to be monitored
    REDIM hWatchThread(dirCount) AS LONG

    FOR i = 1 TO dirCount
        CmdInfo(i).Cmd = TRIM$(REMAIN$(DirList(i), "="))
        CmdInfo(i).Path = TRIM$(EXTRACT$(DirList(i), "="))
        IF DIR$(TRIM$(CmdInfo(i).Path), %SUBDIR) = "" THEN
            PrintLog "Directory " & TRIM$(CmdInfo(i).Path) & " does not exist"
        ELSE
            IF TRIM$(CmdInfo(i).Cmd) <> "" THEN
                THREAD CREATE WatchDirectory(i) TO hWatchThread(i)
            END IF
        END IF
    NEXT i

    '-- Loop forever
    DO
        SLEEP 10

        '-- Exit if service shutdown requested
        IF pbsIsShutdown() THEN EXIT DO
    LOOP

    PrintLog "End Monitor Thread"

    '-- Shut down directory watcher threads
    FOR i = 1 TO dirCount
        THREAD CLOSE hWatchThread(i) TO foo
    NEXT i

    '-- Close log file
    CLOSE #hLogFile

END FUNCTION

'-- This function is started in a thread for each directory to be monitored
FUNCTION WatchDirectory(BYVAL cmdPtr AS LONG) AS LONG
    LOCAL hFile AS LONG
    LOCAL dynBuffer AS LONG
    LOCAL dynBufferSize AS LONG
    LOCAL lpBytesReturned AS INTEGER
    LOCAL lRet AS LONG
    LOCAL ret AS LONG
    LOCAL ptrNext AS LONG
    LOCAL ptrNextOffset AS LONG
    LOCAL ptrAction AS LONG
    LOCAL ptrFileLen AS LONG
    LOCAL ptrFileName AS STRING
    LOCAL sFile AS STRING
    LOCAL sFileOld AS STRING
    LOCAL sOut AS STRING
    LOCAL cnt AS LONG
    LOCAL i AS LONG
    LOCAL sPath AS STRING
    LOCAL sDocPath AS STRING
    LOCAL sCmd AS STRING

    sPath = TRIM$(CmdInfo(cmdPtr).Path)
    PrintLog "Start Monitoring Directory: " & sPath

    '-- Get a handle to the directory
    hFile = CreateFile( BYVAL STRPTR(sPath), %FILE_LIST_DIRECTORY, _
                        %FILE_SHARE_READ OR %FILE_SHARE_WRITE OR %FILE_SHARE_DELETE, _
                        BYVAL 0&, %OPEN_EXISTING, %FILE_FLAG_BACKUP_SEMANTICS, BYVAL 0& )

    '-- Check to see if the handle is valid
    IF NOT hFile = %INVALID_HANDLE_VALUE THEN

        '-- Allocate a buffer large enough for %MAX_FILES at one shot
        dynBufferSize = (12 + (%MAX_PATH * 2)) * %MAX_FILES
        dynBuffer = GlobalAlloc(%GMEM_FIXED, dynBufferSize)

        DO
            '-- Exit if service shutdown requested
            IF pbsIsShutdown() THEN EXIT DO

            lRet = ReadDirectoryChangesW(   hFile, _
                                            dynBuffer, _
                                            dynBufferSize, _
                                            %True, _                         '-- trigger on subdirectories
                                            %FILE_NOTIFY_CHANGE_FILE_NAME, _ '-- Any filename change
                                            lpBytesReturned, _
                                            0&, _
                                            0&  )

            IF (lRet <> 0) AND (lpBytesReturned > 0) THEN
                '-- Go through the FILE_NOTIFY_INFORMATION structure (manually):
                ptrNext = 0
                DO
                    ptrNextOffset = PEEK(dynBuffer + ptrNext)
                    ptrAction = PEEK(dynBuffer + ptrNext + 4)
                    ptrFileLen = PEEK(dynBuffer + ptrNext + 8)
                    sFile = ACODE$(PEEK$(dynBuffer+ptrNext+12, ptrFileLen))

                    SELECT CASE ptrAction
                        CASE %FILE_ACTION_ADDED
                            sOut = "File added: "

                            '-- Exec the command associtated with this directory,
                            '-- passing the document that was added to it
                            sCmd = TRIM$(CmdInfo(CmdPtr).Cmd)
                            sDocPath = $DQ & sPath & "\" & sFile & $DQ
                            PrintLog sCmd & " " & sDocPath
                            lRet = SHELL( sCmd & " " & sDocPath )

                        CASE %FILE_ACTION_REMOVED
                            sOut = "File removed: "
                        CASE %FILE_ACTION_MODIFIED
                            sOut = "File modified: "
                        CASE %FILE_ACTION_RENAMED_OLD_NAME
                            sOut = "Old filename: "
                        CASE %FILE_ACTION_RENAMED_NEW_NAME
                            sOut = "New filename: "
                        CASE ELSE
                            sOut = "Undocumented action!" & STR$(ptrAction)
                    END SELECT

                    sOut = sOut & sPath & "\" & sFile
                    PrintLog sOut

                    ptrNext = ptrNext + ptrNextOffset
                LOOP UNTIL ptrNextOffset = 0

            END IF
        LOOP

        '-- free the memory and close the file
        CALL GlobalFree(dynBuffer)

        IF hFile <> 0 THEN CloseHandle hFile
    ELSE
        PrintLog "Directory could not be opened: " & sPath
    END IF

    PrintLog "End Monitoring Directory: " & sPath

END FUNCTION

'-- Main function
FUNCTION PBMAIN() AS LONG
    LOCAL hMonitorThread AS LONG
    LOCAL foo AS LONG
    LOCAL lRet AS LONG

    '-- If starting service (no -install or -uninstall on command line)
    IF COMMAND$ = "" THEN
        '-- Start the Monitor thread
        THREAD CREATE MonitorThread(0) TO hMonitorThread
        PrintLog "Starting Service"
    END IF

    '-- Install or Start the service
    lRet = pbsInit(0, $SERVICE_NAME, $SERVICE_DISPLAY_NAME)

    IF COMMAND$ = "" THEN
        PrintLog "Ending Service"

        '-- Shutdown the Monitor thread
        THREAD CLOSE hMonitorThread TO foo
    END IF

END FUNCTION
